package com.ejie.ab04b.constantes;

import org.springframework.jdbc.core.JdbcTemplate;

/**
 * Contiene todas las secuencias de la aplicacion, y los metodos para
 * interactuar con ellas
 * 
 * @author GFI-Norte
 * 
 */
public enum Secuencias {

	COD_OBRA_082("SEQ_CODOBRA_082"), //
	ID_APE_056("SEQ_IDAPE_056"), //

	DATOS_NOTIFICACION("SEQ_DATOS_NOTIFICACION"), //
	DATOS_LOCALIZACION("SEQ_DATOS_LOCALIZACION"), //
	DATOS_AVISO("SEQ_DATOS_AVISO"), //
	DATOS_ENVIO_POSTAL("SEQ_DATOS_ENVIO_POSTAL"), //

	TIPOS_OBRAS("SEQ_TIPOS_OBRAS_070"), //
	TIPOS_APERTURAS("SEQ_TIPOS_APERTURAS_071"), //
	CLASES_CENTROS("SEQ_CLASES_CENTROS_072"), //
	MODALIDAD_PREVENTIVA("SEQ_TIPOS_MODALIDAD_074"), //
	ENTIDAD_GESTORA("SEQ_ENTIDAD_GESTORA_078"), //
	EMPRESA_AUDITORA("SEQ_EMPRESA_AUDITORA_079"), //
	SERVICIO_PREVENCION("SEQ_SERVICIO_PREVENCION_080"), //

	TRAMITE_APERTURAS("SEQ_TRAMITE_APERTURAS"), //
	TAREA_APERTURAS("SEQ_TAREA_APERTURAS"), //
	DOC_APERTURAS("SEQ_DOC_APERTURAS"), //

	TRAMITE_OS2("SEQ_TRAMITE_OS2"), //
	TAREA_OS2("SEQ_TAREA_OS2"), //
	DOC_OS2("SEQ_DOC_OS2"), //

	TRAMITE_OS3("SEQ_TRAMITE_OS3"), //
	TAREA_OS3("SEQ_TAREA_OS3"), //
	DOC_OS3("SEQ_DOC_OS3"), //

	NOTIFICACIONES("SEQ_NOTIFICACION_028"), //

	DOC_APERTURAS_TEMP("SEQ_DOC_APERTURAS_TEMP"), //

	ERROR_EVENTO_COLA("SEQ_ERROR_EVENTO_COLA"), //

	DOC_OS2_TEMP("SEQ_DOC_OS2_TEMP"), //

	DOC_OS3_TEMP("SEQ_DOC_OS3_TEMP"); //

	private String codSecuencia;

	/**
	 * Constructor privado de secuencia.
	 * 
	 * codSecuencia String
	 * 
	 * @param codSecuencia
	 *            the cod secuencia
	 */
	private Secuencias(String codSecuencia) {
		this.codSecuencia = codSecuencia;
	}

	/**
	 * Recupera el siguiente valor de la secuencia. Es necesario informar la
	 * plantilla jdbc para tratar con BBDD.
	 * 
	 * jdbcTemplate JdbcTemplate Long
	 * 
	 * @param jdbcTemplate
	 *            the jdbc template
	 * @return the next long
	 */
	public Long getNextLong(JdbcTemplate jdbcTemplate) {
		return jdbcTemplate.queryForLong(Secuencias
				.getSelectNext(this.codSecuencia));
	}

	/**
	 * Recupera el siguiente valor de la secuencia. Es necesario informar la
	 * plantilla jdbc para tratar con BBDD.
	 * 
	 * jdbcTemplate JdbcTemplate Integer
	 * 
	 * @param jdbcTemplate
	 *            the jdbc template
	 * @return the next integer
	 */
	public Integer getNextInteger(JdbcTemplate jdbcTemplate) {
		return jdbcTemplate.queryForInt(Secuencias
				.getSelectNext(this.codSecuencia));
	}

	/**
	 * Recupera el valor actual de la secuencia. Es necesario informar la
	 * plantilla jdbc para tratar con BBDD.
	 * 
	 * jdbcTemplate JdbcTemplate Long
	 * 
	 * @param jdbcTemplate
	 *            the jdbc template
	 * @return the current long
	 */
	public Long getCurrentLong(JdbcTemplate jdbcTemplate) {
		return jdbcTemplate.queryForLong(Secuencias
				.getSelectCurrent(this.codSecuencia));
	}

	/**
	 * Recupera el valor actual de la secuencia. Es necesario informar la
	 * plantilla jdbc para tratar con BBDD.
	 * 
	 * jdbcTemplate JdbcTemplate Integer
	 * 
	 * @param jdbcTemplate
	 *            the jdbc template
	 * @return the current integer
	 */
	public Integer getCurrentInteger(JdbcTemplate jdbcTemplate) {
		return jdbcTemplate.queryForInt(Secuencias
				.getSelectCurrent(this.codSecuencia));
	}

	/**
	 * Devuelve la select que recupera el siguiente valor de la secuencia.
	 * 
	 * secuencia String String
	 * 
	 * @param secuencia
	 *            the secuencia
	 * @return the select next
	 */
	private static String getSelectNext(String secuencia) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT ");
		query.append(secuencia);
		query.append(".NEXTVAL FROM DUAL ");
		return query.toString();
	}

	/**
	 * Devuelve la select que recupera el valor actual de la secuencia.
	 * 
	 * secuencia String String
	 * 
	 * @param secuencia
	 *            the secuencia
	 * @return the select current
	 */
	private static String getSelectCurrent(String secuencia) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT ");
		query.append(secuencia);
		query.append(".CURRVAL FROM DUAL ");
		return query.toString();
	}

	/**
	 * Gets the cod secuencia.
	 * 
	 * String
	 * 
	 * @return the cod secuencia
	 */
	public String getCodSecuencia() {
		return codSecuencia;
	}
}